<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';

header('Content-Type: application/json; charset=utf-8');

$id = (int)($_POST['id'] ?? 0);
if($id <= 0) {
  echo json_encode(['ok'=>false, 'error'=>'شناسه سفارش نامعتبر است']);
  exit;
}

// مقادیر اصلی سفارش
$cust_name = trim($_POST['customer_name'] ?? '');
$address   = trim($_POST['address'] ?? '');
$warranty  = trim($_POST['warranty'] ?? '');
$date      = trim($_POST['purchase_date'] ?? '');
$total_amt = (int)($_POST['total_amount'] ?? 0);
$deposit   = (int)($_POST['total_deposit'] ?? 0);
$remain    = (int)($_POST['total_remaining'] ?? 0);
$notes     = trim($_POST['notes'] ?? '');

// بروزرسانی جدول orders
$stmt = $mysqli->prepare("UPDATE orders 
  SET customer_name=?, address=?, warranty=?, purchase_date=?, total_amount=?, total_deposit=?, total_remaining=?, notes=? 
  WHERE id=?");
$stmt->bind_param('ssssiiisi', $cust_name, $address, $warranty, $date, $total_amt, $deposit, $remain, $notes, $id);
if(!$stmt->execute()){
  echo json_encode(['ok'=>false, 'error'=>'خطا در بروزرسانی سفارش: '.$stmt->error]);
  exit;
}

// حذف اقلام قبلی و درج جدید
$mysqli->query("DELETE FROM order_items WHERE order_id=$id");

$models = $_POST['model'] ?? [];
$prices = $_POST['price'] ?? [];
$deposits = $_POST['deposit'] ?? [];
$cods = $_POST['cod'] ?? [];
$remainings = $_POST['remaining'] ?? [];

if(count($models)){
  $ins = $mysqli->prepare("INSERT INTO order_items (order_id, model, price, deposit, cod, remaining) VALUES (?,?,?,?,?,?)");
  foreach($models as $i=>$m){
    $m = trim($m);
    if(!$m) continue;
    $p = (int)($prices[$i] ?? 0);
    $d = (int)($deposits[$i] ?? 0);
    $c = (int)($cods[$i] ?? 0);
    $r = (int)($remainings[$i] ?? 0);
    $ins->bind_param('isiiii', $id, $m, $p, $d, $c, $r);
    $ins->execute();
  }
}

// موفقیت
echo json_encode(['ok'=>true, 'msg'=>'سفارش و اقلام با موفقیت بروزرسانی شدند.']);
?>
