<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/jdf.php';

$user = $_SESSION['username'];
$is_admin = ($_SESSION['role'] ?? '') === 'admin';

$where = $is_admin ? '1' : "username='".$mysqli->real_escape_string($user)."'";
$q = $mysqli->query("SELECT * FROM orders WHERE $where ORDER BY id DESC");

function nf($n){return number_format((int)$n,0,'.',',');}

// تبدیل تاریخ میلادی به شمسی با اعداد انگلیسی
function toJalaliEn($date){
  if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}$/',$date)) return '-';
  list($gy,$gm,$gd)=explode('-',$date);
  $j=gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
  // تبدیل اعداد فارسی به انگلیسی
  $en = strtr($j, ['۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4','۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9']);
  return $en;
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<meta charset="utf-8">
<title>لیست فاکتورها | سلام‌بابا</title>
<link rel="stylesheet" href="assets/style.css">
<body>
<div class="container">
<?php require __DIR__.'/includes/header.php'; ?>
<section class="card">
  <h3>📦 فاکتورهای ثبت‌شده</h3>
<form id="filterForm" method="get" class="filter-bar" style="display:flex;flex-wrap:wrap;gap:10px;margin-bottom:16px;">
  <input type="text" name="search" placeholder="🔍 جستجو (نام مشتری یا فروشنده)" 
         value="<?=htmlspecialchars($_GET['search'] ?? '')?>" 
         style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;flex:1;min-width:180px;">

  <select name="seller" style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;">
    <option value="">همه فروشنده‌ها</option>
    <?php
      $sellers = $mysqli->query("SELECT DISTINCT seller_name FROM orders ORDER BY seller_name ASC");
      while($s = $sellers->fetch_assoc()):
        $sel = ($_GET['seller'] ?? '') == $s['seller_name'] ? 'selected' : '';
        echo "<option $sel>".htmlspecialchars($s['seller_name'])."</option>";
      endwhile;
    ?>
  </select>

  <select name="month" style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;">
    <option value="">ماه</option>
    <?php
      for($m=1;$m<=12;$m++):
        $sel = ($_GET['month'] ?? '') == $m ? 'selected' : '';
        echo "<option value='$m' $sel>$m</option>";
      endfor;
    ?>
  </select>

  <select name="year" style="padding:8px 12px;border:1px solid #ccc;border-radius:8px;">
    <option value="">سال</option>
    <?php
      $years = $mysqli->query("SELECT DISTINCT YEAR(purchase_date) y FROM orders ORDER BY y DESC");
      while($y = $years->fetch_assoc()):
        $sel = ($_GET['year'] ?? '') == $y['y'] ? 'selected' : '';
        echo "<option $sel>".$y['y']."</option>";
      endwhile;
    ?>
  </select>

  <button class="btn primary" type="submit">اعمال فیلتر</button>
  <a href="order.php" class="btn ghost">حذف فیلتر</a>
</form>

<div id="ordersTable">
  <!-- جدول فعلی اینجا قرار دارد -->
  <table class="table">
    ...
  </table>
</div>

  <table class="table">
    <thead>
      <tr>
        <th>#</th>
        <th>مشتری</th>
        <th>فروشنده</th>
        <th>تاریخ</th>
        <th>جمع فروش</th>
        <th>بیعانه</th>
        <th>مانده</th>
        <th>وضعیت</th>
        <th>عملیات</th>
      </tr>
    </thead>
    <tbody>
      <?php if($q->num_rows==0): ?>
        <tr><td colspan="9" style="text-align:center;color:#777;">هیچ فاکتوری ثبت نشده</td></tr>
      <?php else: $i=1; while($r=$q->fetch_assoc()): ?>
        <tr>
          <td><?=$i++?></td>
          <td><?=htmlspecialchars($r['customer_name'])?></td>
          <td><?=htmlspecialchars($r['seller_name'])?></td>
          <td><?=toJalaliEn($r['purchase_date'])?></td>
          <td><?=nf($r['total_amount'])?></td>
          <td><?=nf($r['total_deposit'])?></td>
          <td><?=nf($r['total_remaining'])?></td>
          <td>
            <?php
            $s = $r['status'];
            $map = [
              'pending' => '🕓 در انتظار',
              'processing' => '🔧 آماده‌سازی',
              'shipped' => '🚚 ارسال شد',
              'delivered' => '✅ تحویل داده شد',
              'cancelled' => '❌ لغو شد'
            ];
            echo $map[$s] ?? 'نامشخص';
            ?>
          </td>
        <td>
  <div class="action-menu">
    <button class="action-btn" aria-label="منوی عملیات">⋯</button>
    <div class="action-list">
      <a href="view.php?id=<?=$r['id']?>" class="btn small primary">👁 مشاهده</a>
      <a href="edit.php?id=<?=$r['id']?>" class="btn small ghost">✏️ ویرایش</a>
      <a href="invoice.php?id=<?=$r['id']?>" class="btn small ghost">🧾 PDF</a>
      <a href="invoice_print.php?id=<?=$r['id']?>" class="btn small ghost">🖨 پرینت</a>
      <?php if($is_admin): ?>
        <button class="btn small danger" onclick="deleteOrder(<?=$r['id']?>)">🗑 حذف</button>
      <?php endif; ?>
    </div>
  </div>
</td>

        </tr>
      <?php endwhile; endif; ?>
    </tbody>
  </table>
</section>

<script>
async function deleteOrder(id){
  if(!confirm('آیا از حذف این فاکتور مطمئن هستید؟')) return;
  const fd = new FormData();
  fd.append('id', id);
  const r = await fetch('xhr_delete_order.php',{method:'POST',body:fd});
  const j = await r.json();
  alert(j.msg);
  if(j.ok) location.reload();
}
</script>
<div class="table-wrapper">
  <table class="table"> ... </table>
</div>

</div>
<script>
document.addEventListener('click', e => {
  // بستن همه منوها
  document.querySelectorAll('.action-menu').forEach(m => m.classList.remove('active'));
  // باز کردن منوی موردنظر
  if (e.target.closest('.action-btn')) {
    e.stopPropagation();
    e.target.closest('.action-menu').classList.toggle('active');
  }
});
</script>

<script>
document.addEventListener('click', e => {
  // بستن همه‌ی منوها
  document.querySelectorAll('.dropdown-clean').forEach(el => el.classList.remove('active'));

  // باز کردن منوی انتخاب‌شده
  const trigger = e.target.closest('.trigger');
  if (trigger) {
    e.stopPropagation();
    trigger.closest('.dropdown-clean').classList.toggle('active');
  }
});
</script>
<script>
const form = document.getElementById('filterForm');
form.addEventListener('change', doFilter);
form.addEventListener('submit', e => { e.preventDefault(); doFilter(); });

async function doFilter(){
  const params = new URLSearchParams(new FormData(form));
  const tableBody = document.querySelector('#ordersTable tbody');
  tableBody.innerHTML = '<tr><td colspan="9" style="text-align:center;color:#777;">در حال بارگذاری...</td></tr>';

  const res = await fetch('xhr_filter_orders.php?' + params.toString());
  const data = await res.json();
  tableBody.innerHTML = data.html;

  // دوباره listener برای منوی سه‌نقطه اعمال بشه
  document.querySelectorAll('.action-btn').forEach(btn=>{
    btn.addEventListener('click', e=>{
      e.stopPropagation();
      btn.closest('.action-menu').classList.toggle('active');
    });
  });
}
</script>

</body>
</html>
