<?php
require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';

$q = trim($_GET['q'] ?? '');

// جستجو
if ($q !== '') {
    $stmt = $mysqli->prepare("SELECT * FROM products 
        WHERE model LIKE CONCAT('%',?,'%') 
           OR brand LIKE CONCAT('%',?,'%')
        ORDER BY id DESC");
    $stmt->bind_param("ss", $q, $q);
    $stmt->execute();
    $products = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
} else {
    $products = $mysqli->query("SELECT * FROM products ORDER BY id DESC")->fetch_all(MYSQLI_ASSOC);
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>مدیریت محصولات</title>
<link rel="stylesheet" href="assets/style.css">
<style>
.table { width:100%; border-collapse: collapse; }
.table th, .table td { padding:10px; border-bottom:1px solid #ddd; }
.table tr:hover{ background:#f1f1f1; }
.actions a { margin-left:10px; }
</style>
</head>
<body>

<?php require __DIR__.'/includes/header.php'; ?>

<div class="container card">
  <h2>مدیریت محصولات</h2>

  <form method="get">
    <input name="q" placeholder="جستجوی مدل یا برند" value="<?=htmlspecialchars($q)?>">
    <button class="btn primary">جستجو</button>
    <a href="product_add.php" class="btn success">+ افزودن محصول</a>
  </form>

  <table class="table">
    <thead>
      <tr>
        <th>شناسه</th>
        <th>برند</th>
        <th>مدل</th>
        <th>دسته</th>
        <th>قیمت پیش‌فرض</th>
        <th>عملیات</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($products as $p): ?>
      <tr>
        <td><?=$p['id']?></td>
        <td><?=$p['brand']?></td>
        <td><?=$p['model']?></td>
        <td><?=$p['category']?></td>
        <td><?=number_format($p['default_price'])?></td>
        <td class="actions">
          <a href="product_edit.php?id=<?=$p['id']?>" class="btn small">ویرایش</a>
          <a href="product_delete.php?id=<?=$p['id']?>" class="btn danger small" onclick="return confirm('حذف شود؟')">حذف</a>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

</div>

</body>
</html>
