<?php
error_reporting(E_ALL);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__.'/php-error.log');

require __DIR__.'/includes/auth.php';
require __DIR__.'/includes/config.php';
require __DIR__.'/includes/db_connect.php';
require __DIR__.'/includes/jalali.php';
require __DIR__.'/includes/helpers.php';
require __DIR__.'/includes/telegram.php';

/* ============================
   Helpers
============================ */
function toInt($s){
    return (int)preg_replace('/[^\d]/','',(string)$s);
}

/**
 * نرمال‌سازی اقلام فاکتور
 * پشتیبانی از هر دو ساختار:
 *  - جدید: items[0]['model'] ...
 *  - قدیمی: items['model'][0] ...
 */
function normalize_items($items){
    // ساختار جدید: آرایه‌ای از ردیف‌ها
    if (isset($items[0]) && is_array($items[0])) {
        $out = [];
        foreach ($items as $it) {
            $out[] = [
                'model'         => trim($it['model'] ?? ''),
                'price'         => toInt($it['price'] ?? 0),
                'deposit'       => toInt($it['deposit'] ?? 0),
                'cod'           => toInt($it['cod'] ?? 0),
                'remaining'     => toInt($it['remaining'] ?? 0),
                'qty'           => max(1, toInt($it['qty'] ?? 1)),
                'warranty_type' => trim($it['warranty_type'] ?? 'none'),
                'notes'         => trim($it['notes'] ?? ''),
                'brand'         => trim($it['brand'] ?? ''),
                'category'      => trim($it['category'] ?? ''),
            ];
        }
        return $out;
    }

    // ساختار قدیمی: items['model'][i]
    if (isset($items['model'])) {
        $count = max(
            count($items['model']),
            count($items['price'] ?? []),
            count($items['deposit'] ?? []),
            count($items['cod'] ?? []),
            count($items['remaining'] ?? []),
            count($items['qty'] ?? []),
            count($items['warranty_type'] ?? []),
            count($items['notes'] ?? []),
        );
        $out = [];
        for ($i=0; $i<$count; $i++){
            $out[] = [
                'model'         => trim($items['model'][$i] ?? ''),
                'price'         => toInt($items['price'][$i] ?? 0),
                'deposit'       => toInt($items['deposit'][$i] ?? 0),
                'cod'           => toInt($items['cod'][$i] ?? 0),
                'remaining'     => toInt($items['remaining'][$i] ?? 0),
                'qty'           => max(1, toInt($items['qty'][$i] ?? 1)),
                'warranty_type' => trim($items['warranty_type'][$i] ?? 'none'),
                'notes'         => trim($items['notes'][$i] ?? ''),
                'brand'         => trim($items['brand'][$i] ?? ''),
                'category'      => trim($items['category'][$i] ?? ''),
            ];
        }
        return $out;
    }

    return [];
}

/* ============================
   دریافت داده‌ها از فرم
============================ */
$customer_name = trim($_POST['customer_name'] ?? '');
$seller_name   = trim($_POST['seller_name'] ?? ($_SESSION['full_name'] ?? $_SESSION['username']));
$mobile1       = trim($_POST['mobile1'] ?? '');
$mobile2       = trim($_POST['mobile2'] ?? '');
$phone         = trim($_POST['phone'] ?? '');
$province      = trim($_POST['province'] ?? '');
$address       = trim($_POST['address'] ?? '');
$location_url  = trim($_POST['location_url'] ?? '');
$notes         = trim($_POST['notes'] ?? '');

$targets        = $_POST['target'] ?? [];
$withdraw_amount= toInt($_POST['withdraw_amount'] ?? 0);
$withdraw_note  = trim($_POST['withdraw_note'] ?? '');

/* لجستیک */
$buyer_username = trim($_POST['buyer_username'] ?? '');
if ($buyer_username === '') {
    $buyer_username = null;
}
$shipping_status = $buyer_username ? 'assigned_to_buyer' : 'new';

/* تاریخ خرید */
$purchase_date_raw = fa2en($_POST['purchase_date'] ?? '');
$purchase_date_sh  = fa2en($_POST['purchase_date_sh'] ?? '');

if (preg_match('/^\d{4}-\d{2}-\d{2}$/', $purchase_date_raw)) {
    $purchase_date = $purchase_date_raw;
} else {
    $purchase_date = jdate_to_gdate_ymd($purchase_date_sh) ?: date('Y-m-d');
}

/* اقلام */
$items_raw = $_POST['items'] ?? [];
$items     = normalize_items($items_raw);

/* حذف سطرهای خالی */
$items = array_values(array_filter($items, function($it){
    return trim($it['model']) !== '' || ((int)$it['price'] > 0);
}));

/* اعتبارسنجی پایه */
if ($customer_name === '' || empty($items)) {
    exit("❌ پارامترها ناقص است.");
}

/* ============================
   محاسبه مبالغ
============================ */
$sum_p = 0;
$sum_d = 0;
$sum_c = 0;
$sum_r = 0;

foreach ($items as &$it){
    $unit  = (int)$it['price'];
    $qty   = max(1, (int)$it['qty']);
    $total = $unit * $qty;
    $dep   = (int)$it['deposit'];
    $cod   = (int)$it['cod'];

    $it['price']     = $total;
    $it['remaining'] = $total - $dep - $cod;

    $sum_p += $total;
    $sum_d += $dep;
    $sum_c += $cod;
    $sum_r += $it['remaining'];
}
unset($it);

$order_warranty = 'none';

/* ============================
   INSERT در orders (هماهنگ با جدول واقعی)
   جدول: orders
   ستون‌ها که پر می‌کنیم:
   status, shipping_status, username, buyer_username,
   customer_name, mobile1, mobile2, phone,
   province, address, seller_name, warranty,
   purchase_date, total_amount, total_deposit,
   total_cod, total_remaining, notes, location_url
============================ */

$mysqli->begin_transaction();

try {

    $st = $mysqli->prepare("
        INSERT INTO orders (
            status,
            shipping_status,
            username,
            buyer_username,
            customer_name,
            mobile1,
            mobile2,
            phone,
            province,
            address,
            seller_name,
            warranty,
            purchase_date,
            total_amount,
            total_deposit,
            total_cod,
            total_remaining,
            notes,
            location_url
        ) VALUES (
            'pending',
            ?,
            ?,
            ?,
            ?,
            ?,
            ?,
            ?,
            ?,
            ?,
            ?,
            ?,
            ?,
            ?,
            ?,
            ?,
            ?,
            ?,
            ?
        )
    ");

    // 18 پارامتر → 18 کاراکتر در رشته تایپ
    // s: 12 تا اول + notes + location_url = 14؟ نه، دقت کن:
    // shipping_status, username, buyer_username, customer_name,
    // mobile1, mobile2, phone, province, address, seller_name,
    // warranty, purchase_date, notes, location_url
    // یعنی 14 تا string + 4 تا int
    $st->bind_param(
        "ssssssssssssiiiiss",
        $shipping_status,              // 1: s
        $_SESSION['username'],         // 2: s
        $buyer_username,               // 3: s (NULL هم اوکی)
        $customer_name,                // 4: s
        $mobile1,                      // 5: s
        $mobile2,                      // 6: s
        $phone,                        // 7: s
        $province,                     // 8: s
        $address,                      // 9: s
        $seller_name,                  // 10: s
        $order_warranty,               // 11: s
        $purchase_date,                // 12: s
        $sum_p,                        // 13: i
        $sum_d,                        // 14: i
        $sum_c,                        // 15: i
        $sum_r,                        // 16: i
        $notes,                        // 17: s
        $location_url                  // 18: s
    );

    $st->execute();
    $oid = $st->insert_id;
    $st->close();

    /* ============================
       UID یکتا
    ============================ */
    function gen_uid($len=5){
        $a = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        $r = "";
        for($i=0;$i<$len;$i++){
            $r .= $a[random_int(0, strlen($a)-1)];
        }
        return $r;
    }

    $uid = null;
    do {
        $c = gen_uid();
        $chk = $mysqli->prepare("SELECT 1 FROM orders WHERE order_uid=? LIMIT 1");
        $chk->bind_param("s", $c);
        $chk->execute();
        $e = $chk->get_result()->num_rows;
        $chk->close();
        if(!$e) $uid = $c;
    } while(!$uid);

    $up = $mysqli->prepare("UPDATE orders SET order_uid=? WHERE id=?");
    $up->bind_param("si", $uid, $oid);
    $up->execute();
    $up->close();

    /* ============================
       ITEMS
    ============================ */
    $sti = $mysqli->prepare("
        INSERT INTO order_items
            (order_id, model, qty, price, deposit, cod, remaining, warranty_type, notes)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    foreach($items as $it){
        $sti->bind_param(
            "isiiiiiss",
            $oid,
            $it['model'],
            $it['qty'],
            $it['price'],
            $it['deposit'],
            $it['cod'],
            $it['remaining'],
            $it['warranty_type'],
            $it['notes']
        );
        $sti->execute();
    }
    $sti->close();

    /* ============================
       برداشت از حساب
    ============================ */
    if ($withdraw_amount > 0) {
        $stw = $mysqli->prepare("INSERT INTO withdrawals (order_id, amount, note) VALUES (?, ?, ?)");
        $stw->bind_param("iis", $oid, $withdraw_amount, $withdraw_note);
        $stw->execute();
        $stw->close();
    }

    /* ============================
       شماره فاکتور + tracking_code
    ============================ */
    $digits  = str_pad((string)random_int(0, 99999), 5, '0', STR_PAD_LEFT);
    $letters = chr(random_int(65, 90)).chr(random_int(65, 90));
    $invoice = "SB-{$digits}-{$letters}";
    $tracking= $invoice;

    $u2 = $mysqli->prepare("UPDATE orders SET invoice_no=?, tracking_code=? WHERE id=?");
    $u2->bind_param("ssi", $invoice, $tracking, $oid);
    $u2->execute();
    $u2->close();

    $mysqli->commit();

} catch(Throwable $e){
    $mysqli->rollback();
    exit("❌ DB INSERT ERROR: ".$e->getMessage());
}

/* ============================
   Telegram
============================ */
$track_url = BASE_URL.'track.php?code='.$tracking;

$wmap = [
    'none'           => 'بدون گارانتی',
    'tv_silver'      => 'نقره‌ای تلویزیون',
    'tv_gold'        => 'طلایی تلویزیون',
    'home_appliance' => 'لوازم خانگی',
    'small_appliance'=> 'لوازم ریز'
];

$txt  = "🧾 <b>فاکتور جدید</b>\n#{$invoice}\n";
$txt .= "👤 {$customer_name}\n";
if($mobile1) $txt .= "📱 {$mobile1}\n";
if($mobile2) $txt .= "📱 {$mobile2}\n";
if($phone)   $txt .= "☎ {$phone}\n";
if($province)$txt .= "📍 استان: {$province}\n";
if($location_url) $txt .= "📍 لوکیشن: {$location_url}\n";
$txt .= "👨‍💼 فروشنده: {$seller_name}\n";
$txt .= "📅 تاریخ: {$purchase_date}\n";
$txt .= "📍 {$address}\n\n";

$txt .= "<b>اقلام:</b>\n";
$i = 1;
foreach($items as $it){
    $unit = ($it['qty'] > 0) ? floor($it['price'] / $it['qty']) : $it['price'];
    $txt .= "{$i}) {$it['model']}\n";
    $txt .= "🔢 {$it['qty']}\n";
    $txt .= "💵 واحد: ".nf($unit)."\n";
    $txt .= "💰 کل: ".nf($it['price'])."\n";
    $txt .= "💳 بیعانه: ".nf($it['deposit'])."\n";
    $txt .= "💳 COD: ".nf($it['cod'])."\n";
    $txt .= "🧮 مانده: ".nf($it['remaining'])."\n";
    $txt .= "🛡 ".($wmap[$it['warranty_type']] ?? "—")."\n";
    if(!empty($it['notes'])) {
        $txt .= "📝 ".$it['notes']."\n";
    }
    $txt .= "────────────\n";
    $i++;
}

$txt .= "<b>جمع کل:</b> ".nf($sum_p)."\n";
$txt .= "<b>بیعانه:</b> ".nf($sum_d)."\n";
$txt .= "<b>COD:</b> ".nf($sum_c)."\n";
$txt .= "<b>مانده:</b> ".nf($sum_r)."\n";
$txt .= "\n🔗 {$track_url}\n";

/* ارسال تلگرام */
foreach($targets as $t){
    if(isset($CHAT_MAP[$t])){
        tg_send_message($BOT_TOKEN, $CHAT_MAP[$t], $txt);
    }
}

/* پایان: هدایت به صفحه فاکتور با order_uid */
header("Location: invoice.php?id={$uid}");
exit;
