<?php
require __DIR__.'/../includes/auth.php';
require __DIR__.'/../includes/config.php';
require __DIR__.'/../includes/db_connect.php';
require __DIR__.'/../includes/header.php';


$role = $_SESSION['role'] ?? '';
if ($role !== 'admin') {
  die('<p style="text-align:center;color:red;margin-top:30px">فقط مدیر می‌تواند به این صفحه دسترسی داشته باشد.</p>');
}

// تغییر وضعیت (approve / reject)
if (isset($_GET['action'], $_GET['id'])) {
  $id = (int)$_GET['id'];
  $action = ($_GET['action'] === 'approve') ? 'approved' : 'rejected';
  $mysqli->query("UPDATE settlements SET status='$action' WHERE id=$id");
  header("Location: settlement_list.php");
  exit;
}

$q = $mysqli->query("SELECT * FROM settlements ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>لیست درخواست‌های تسویه | سلام‌بابا</title>
<meta name="viewport" content="width=device-width,initial-scale=1.0">
<style>
body {
  font-family: 'IRANYekan', sans-serif;
  background: #f7f8fa;
  padding: 40px 20px;
  color: #333;
}
table {
  width: 100%;
  border-collapse: collapse;
  background: #fff;
  border-radius: 12px;
  overflow: hidden;
  box-shadow: 0 3px 8px rgba(0,0,0,0.05);
}
th, td {
  padding: 12px 10px;
  text-align: center;
  border-bottom: 1px solid #eee;
}
th { background: #007bff; color: white; }
tr:hover { background: #f1f5f9; }
.status-pending { color: #f59e0b; font-weight: bold; }
.status-approved { color: #16a34a; font-weight: bold; }
.status-rejected { color: #dc2626; font-weight: bold; }
a.btn {
  padding: 6px 12px;
  border-radius: 8px;
  text-decoration: none;
  color: white;
  font-size: 0.9rem;
  margin: 2px;
  display: inline-block;
}
.approve { background: #16a34a; }
.reject { background: #dc2626; }
.approve:hover { background: #15803d; }
.reject:hover { background: #b91c1c; }
</style>
</head>
<body>

<h2 style="text-align:center;margin-bottom:25px;">📋 لیست درخواست‌های تسویه</h2>

<table>
  <tr>
    <th>شناسه</th>
    <th>فروشنده</th>
    <th>مبلغ (تومان)</th>
    <th>توضیحات</th>
    <th>تاریخ</th>
    <th>وضعیت</th>
    <th>عملیات</th>
  </tr>
  <?php while($r = $q->fetch_assoc()): ?>
  <tr>
    <td><?= $r['id'] ?></td>
    <td><?= htmlspecialchars($r['username']) ?></td>
    <td><?= number_format($r['amount']) ?></td>
    <td><?= htmlspecialchars($r['note']) ?></td>
    <td><?= date('Y/m/d H:i', strtotime($r['created_at'])) ?></td>
    <td class="status-<?= $r['status'] ?>"><?= strtoupper($r['status']) ?></td>
    <td>
      <?php if ($r['status'] === 'pending'): ?>
        <a href="?action=approve&id=<?= $r['id'] ?>" class="btn approve">تأیید ✅</a>
        <a href="?action=reject&id=<?= $r['id'] ?>" class="btn reject">رد ❌</a>
      <?php else: ?>
        <span style="color:#777;">—</span>
      <?php endif; ?>
    </td>
  </tr>
  <?php endwhile; ?>
</table>

<p style="text-align:center;margin-top:25px;">
  <a href="index.php" style="color:#007bff;text-decoration:none;">⬅ بازگشت به داشبورد</a>
</p>

</body>
</html>
