<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';
require __DIR__ . '/../includes/jdf.php';
require __DIR__ . '/../includes/header.php';

function nf($n){
    return number_format((int)($n ?? 0), 0, '.', ',');
}
function e($v){
    return htmlspecialchars((string)($v ?? ''), ENT_QUOTES, 'UTF-8');
}
if (!function_exists('toJalaliEn')) {
    function toJalaliEn($date){
        if(!$date || !preg_match('/^\d{4}-\d{2}-\d{2}/',$date)) return '-';
        $date = substr($date,0,10);
        list($gy,$gm,$gd) = explode('-',$date);
        if(!function_exists('gregorian_to_jalali')) return $date;
        $j = gregorian_to_jalali((int)$gy,(int)$gm,(int)$gd,'/');
        return strtr($j, [
            '۰'=>'0','۱'=>'1','۲'=>'2','۳'=>'3','۴'=>'4',
            '۵'=>'5','۶'=>'6','۷'=>'7','۸'=>'8','۹'=>'9'
        ]);
    }
}

$role       = $_SESSION['role'] ?? '';
$login_user = $_SESSION['username'] ?? '';

$requested_user = trim($_GET['username'] ?? '');

// اگر یوزرنیم داده نشده، برای خود کاربر
if ($requested_user === '') {
    $requested_user = $login_user;
}

// اگر فروشنده است، فقط اجازه دیدن خودش را دارد
if ($role !== 'admin' && $requested_user !== $login_user) {
    http_response_code(403);
    echo "<div style='padding:20px;color:#b91c1c;font-weight:bold;'>دسترسی غیرمجاز</div>";
    exit;
}

// گرفتن اطلاعات فروشنده
$stmt = $mysqli->prepare("
    SELECT username, full_name
    FROM users
    WHERE username = ?
    LIMIT 1
");
$stmt->bind_param('s', $requested_user);
$stmt->execute();
$res  = $stmt->get_result();
$user = $res->fetch_assoc();
$stmt->close();

if (!$user) {
    echo "<div style='padding:20px;color:#b91c1c;font-weight:bold;'>فروشنده پیدا نشد.</div>";
    exit;
}

// جمع بیعانه‌ها و مقادیر کلی از orders
$stmt = $mysqli->prepare("
    SELECT 
        COALESCE(SUM(total_deposit),0)   AS total_deposit,
        COALESCE(SUM(total_amount),0)    AS total_amount,
        COALESCE(SUM(total_cod),0)       AS total_cod,
        COALESCE(SUM(total_remaining),0) AS total_remaining
    FROM orders
    WHERE username = ?
");
$stmt->bind_param('s', $requested_user);
$stmt->execute();
$res = $stmt->get_result();
$agg_orders = $res->fetch_assoc();
$stmt->close();

$total_deposit   = (int)($agg_orders['total_deposit'] ?? 0);
$total_amount    = (int)($agg_orders['total_amount'] ?? 0);
$total_cod       = (int)($agg_orders['total_cod'] ?? 0);
$total_remaining = (int)($agg_orders['total_remaining'] ?? 0);

// جمع برداشت‌ها
$stmt = $mysqli->prepare("
    SELECT COALESCE(SUM(amount),0) AS total_withdraw
    FROM withdrawals
    WHERE username = ?
");
$stmt->bind_param('s', $requested_user);
$stmt->execute();
$res = $stmt->get_result();
$row = $res->fetch_assoc();
$stmt->close();

$total_withdraw = (int)($row['total_withdraw'] ?? 0);

// مانده
$current_balance = $total_deposit - $total_withdraw;

// لیست فاکتورها
$stmt = $mysqli->prepare("
    SELECT id, order_uid, invoice_no, customer_name, purchase_date,
           total_amount, total_deposit, total_cod, total_remaining, status
    FROM orders
    WHERE username = ?
    ORDER BY id DESC
");
$stmt->bind_param('s', $requested_user);
$stmt->execute();
$orders_res = $stmt->get_result();
$orders = $orders_res->fetch_all(MYSQLI_ASSOC);
$stmt->close();

// لیست برداشت‌ها
$stmt = $mysqli->prepare("
    SELECT w.id, w.amount, w.method, w.note, w.created_at,
           o.order_uid, o.invoice_no
    FROM withdrawals w
    LEFT JOIN orders o ON o.id = w.order_id
    WHERE w.username = ?
    ORDER BY w.id DESC
");
$stmt->bind_param('s', $requested_user);
$stmt->execute();
$wres = $stmt->get_result();
$withdraws = $wres->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>

<link rel="stylesheet" href="../assets/style.css">

<style>
.finance-wrapper{
  max-width:1200px;
  margin:20px auto 40px;
  padding:0 10px;
}
.finance-header{
  display:flex;
  justify-content:space-between;
  align-items:center;
  margin-bottom:20px;
}
.finance-header h1{
  font-size:22px;
  font-weight:700;
}
.finance-cards{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(220px,1fr));
  gap:12px;
  margin-bottom:25px;
}
.fin-card{
  background:#ffffff;
  border-radius:14px;
  border:1px solid #e5e7eb;
  padding:14px 16px;
  box-shadow:0 1px 4px rgba(15,23,42,0.04);
}
.fin-card .label{
  font-size:13px;
  color:#6b7280;
  margin-bottom:6px;
}
.fin-card .value{
  font-size:18px;
  font-weight:700;
  color:#0f172a;
}
.fin-card .sub{
  font-size:12px;
  color:#9ca3af;
  margin-top:4px;
}
.fin-card.main-balance{
  border:1px solid #0ea5e9;
  box-shadow:0 0 0 1px rgba(14,165,233,0.12);
}

.table-card{
  background:#ffffff;
  border-radius:16px;
  border:1px solid #e5e7eb;
  padding:16px;
  margin-top:18px;
  box-shadow:0 1px 4px rgba(15,23,42,0.04);
}
.table-card h2{
  font-size:16px;
  margin:0 0 10px;
}
.table-responsive{
  width:100%;
  overflow-x:auto;
}
.table{
  width:100%;
  border-collapse:collapse;
  font-size:13px;
}
.table th,
.table td{
  border-bottom:1px solid #f1f5f9;
  padding:6px 8px;
  white-space:nowrap;
}
.table th{
  background:#f9fafb;
  font-weight:600;
  color:#4b5563;
}
.badge-status{
  display:inline-block;
  padding:2px 8px;
  border-radius:999px;
  font-size:11px;
}
.badge-status.pending{background:#fef3c7;color:#92400e;}
.badge-status.shipped{background:#dcfce7;color:#166534;}
.badge-status.canceled{background:#fee2e2;color:#b91c1c;}
.badge-method{
  display:inline-block;
  padding:2px 8px;
  border-radius:999px;
  font-size:11px;
}
.badge-method.bank{background:#dbeafe;color:#1d4ed8;}
.badge-method.cash{background:#dcfce7;color:#15803d;}
.badge-method.wallet{background:#fee2e2;color:#b91c1c;}

@media (max-width:768px){
  .finance-header{
    flex-direction:column;
    align-items:flex-start;
    gap:6px;
  }
}
</style>

<div class="finance-wrapper">

  <div class="finance-header">
    <h1>حساب مالی فروشنده: <?= e($user['full_name'] ?: $user['username']) ?></h1>
    <div style="font-size:13px;color:#6b7280;">
      یوزرنیم: <strong><?= e($user['username']) ?></strong>
      <?php if($role === 'admin'): ?>
        &nbsp;|&nbsp; نقش شما: مدیر
      <?php endif; ?>
    </div>
  </div>

  <div class="finance-cards">
    <div class="fin-card main-balance">
      <div class="label">مانده قابل برداشت</div>
      <div class="value"><?= nf($current_balance) ?> تومان</div>
      <div class="sub">جمع بیعانه‌ها − جمع برداشت‌ها</div>
    </div>

    <div class="fin-card">
      <div class="label">جمع بیعانه‌های ثبت شده</div>
      <div class="value"><?= nf($total_deposit) ?> تومان</div>
      <div class="sub">از روی فاکتورهای ثبت شده</div>
    </div>

    <div class="fin-card">
      <div class="label">جمع برداشت‌های ثبت شده</div>
      <div class="value"><?= nf($total_withdraw) ?> تومان</div>
      <div class="sub">تمام برداشت‌ها از جدول withdrawals</div>
    </div>

    <div class="fin-card">
      <div class="label">جمع کل مبلغ فاکتورها</div>
      <div class="value"><?= nf($total_amount) ?> تومان</div>
      <div class="sub">total_amount برای این فروشنده</div>
    </div>
  </div>

  <div class="table-card">
    <h2>📄 فاکتورهای این فروشنده</h2>
    <div class="table-responsive">
      <table class="table">
        <thead>
        <tr>
          <th>#</th>
          <th>فاکتور</th>
          <th>مشتری</th>
          <th>تاریخ خرید</th>
          <th>وضعیت</th>
          <th>جمع فاکتور</th>
          <th>بیعانه</th>
          <th>COD</th>
          <th>مانده</th>
          <th>لینک</th>
        </tr>
        </thead>
        <tbody>
        <?php if(!$orders): ?>
          <tr><td colspan="10" style="text-align:center;color:#9ca3af;">فاکتوری ثبت نشده است.</td></tr>
        <?php else: ?>
          <?php $i=1; foreach($orders as $o): ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= e($o['invoice_no']) ?></td>
              <td><?= e($o['customer_name']) ?></td>
              <td><?= toJalaliEn($o['purchase_date']) ?></td>
              <td>
                <?php
                  $st = $o['status'] ?? 'pending';
                  $cls = 'pending';
                  if ($st === 'shipped') $cls = 'shipped';
                  elseif ($st === 'canceled') $cls = 'canceled';
                ?>
                <span class="badge-status <?= $cls ?>"><?= e($st) ?></span>
              </td>
              <td><?= nf($o['total_amount']) ?></td>
              <td><?= nf($o['total_deposit']) ?></td>
              <td><?= nf($o['total_cod']) ?></td>
              <td><?= nf($o['total_remaining']) ?></td>
              <td>
                <?php if(!empty($o['order_uid'])): ?>
                  <a href="../view.php?id=<?= e($o['order_uid']) ?>" target="_blank">مشاهده</a>
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <div class="table-card">
    <h2>💸 سوابق برداشت از حساب</h2>
    <div class="table-responsive">
      <table class="table">
        <thead>
        <tr>
          <th>#</th>
          <th>تاریخ</th>
          <th>مبلغ</th>
          <th>روش</th>
          <th>توضیحات</th>
          <th>فاکتور مرتبط</th>
        </tr>
        </thead>
        <tbody>
        <?php if(!$withdraws): ?>
          <tr><td colspan="6" style="text-align:center;color:#9ca3af;">برداشتی ثبت نشده است.</td></tr>
        <?php else: ?>
          <?php $i=1; foreach($withdraws as $w): ?>
            <tr>
              <td><?= $i++ ?></td>
              <td><?= toJalaliEn(substr($w['created_at'],0,10)) ?></td>
              <td><?= nf($w['amount']) ?></td>
              <td>
                <span class="badge-method <?= e($w['method']) ?>">
                  <?= $w['method'] === 'bank' ? 'واریز بانکی' : ($w['method'] === 'cash' ? 'نقدی' : 'کیف پول') ?>
                </span>
              </td>
              <td><?= e($w['note']) ?></td>
              <td>
                <?php if(!empty($w['order_uid'])): ?>
                  <a href="../view.php?id=<?= e($w['order_uid']) ?>" target="_blank">مشاهده</a>
                <?php else: ?>
                  -
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

</div>
