<?php
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/config.php';
require __DIR__ . '/../includes/db_connect.php';

$role     = $_SESSION['role']     ?? '';
$username = $_SESSION['username'] ?? '';

if ($role !== 'logistic' && $role !== 'admin') {
    exit('ACCESS DENIED');
}

$id           = (int)($_POST['id'] ?? 0);
$deliver_date = trim($_POST['deliver_date'] ?? '');
$deliver_note = trim($_POST['deliver_note'] ?? '');

if ($id < 1 || $deliver_date === '') {
    exit('bad data');
}

$status_note = "تحویل موفق در تاریخ $deliver_date";
if ($deliver_note !== '') {
    $status_note .= " | توضیح: ".$deliver_note;
}

// آپدیت سفارش
if ($role === 'admin') {
    $stmt = $mysqli->prepare("
        UPDATE orders
        SET shipping_status='delivered', status_note=?, delivered_at=NOW()
        WHERE id=? LIMIT 1
    ");
    $stmt->bind_param("si", $status_note, $id);
} else {
    $stmt = $mysqli->prepare("
        UPDATE orders
        SET shipping_status='delivered', status_note=?, delivered_at=NOW()
        WHERE id=? AND head_carrier_username=? LIMIT 1
    ");
    $stmt->bind_param("sis", $status_note, $id, $username);
}
$stmt->execute();

// نوتیفیکیشن
$info = $mysqli->query("SELECT username, customer_name FROM orders WHERE id=".$id." LIMIT 1")->fetch_assoc();
if ($info) {
    $seller   = $mysqli->real_escape_string($info['username'] ?? '');
    $customer = $mysqli->real_escape_string($info['customer_name'] ?? '');
    if ($seller !== '') {
        $msg = "سفارش مشتری $customer با موفقیت تحویل شد.";
        $mysqli->query("
            INSERT INTO notifications (username, type, order_id, title, message, created_at)
            VALUES (
              '$seller',
              'status',
              $id,
              'تحویل موفق',
              '$msg',
              NOW()
            )
        ");
    }
}

header("Location: logistic_view.php?id=".$id);
exit;
