<?php
require __DIR__ . '/includes/auth.php';
require __DIR__ . '/includes/config.php';
require __DIR__ . '/includes/db_connect.php';

// لیست مسئول‌های خرید
$buyers = [];
$resBuyers = $mysqli->query("SELECT username, full_name FROM users WHERE role='buyer_manager' ORDER BY full_name");
if ($resBuyers) {
    while ($row = $resBuyers->fetch_assoc()) {
        $buyers[] = $row;
    }
}
$telegram_channels = [];
$resTC = $mysqli->query("SELECT * FROM telegram_channels WHERE is_active=1 ORDER BY sort_order ASC, id ASC");
if ($resTC) {
    while ($row = $resTC->fetch_assoc()) {
        $telegram_channels[] = $row;
    }
}

?>

<!doctype html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>ثبت فاکتور — سلام‌بابا</title>

  <!-- استایل اصلی -->
  <link rel="stylesheet" href="assets/style.css">

  <!-- تقویم شمسی -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css">
  <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/persian-date@1.1.0/dist/persian-date.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.min.js"></script>

  <!-- Select2 -->
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
</head>

<body>
<div class="container">
<header class="brand">
  <?php require __DIR__ . '/includes/header.php'; ?>
</header>
<form action="send.php" method="post" id="invoiceForm">
<!-- =================== ورود سریع =================== -->
<section class="quick-paste-box">
  <h3>ورود سریع اطلاعات از متن</h3>

  <textarea id="quickPaste" placeholder="متن خام را اینجا پیست کنید.
هر کدام از اطلاعات در یک لاین
علی رضایی
09121234567
09351234567
02112345678
1404/04/27
تهران، خیابان آزادی، پلاک ۱۲
https://maps.app.goo.gl/
توضیحات فاکتور.."
></textarea>

  <button type="button" id="parseQuickPaste">تجزیه و درج اطلاعات</button>
</section>


<!-- =================== مشخصات مشتری =================== -->
<section class="card">
  <h3>مشخصات مشتری</h3>
  <div class="grid-2">
    <label class="field">
      <span>نام مشتری </span>
      <input name="customer_name" value="محمد عزیزی">
    </label>

    <label class="field">
      <span>نام فروشنده </span>
      <input type="hidden" name="seller_name" value="<?=htmlspecialchars($_SESSION['full_name'])?>">
      <input type="text" value="<?=htmlspecialchars($_SESSION['full_name'])?>" class="sellerInput" readonly tabindex="-1">
    </label>
  </div>

  <div class="grid-2">
    <label class="field">
      <span>شماره همراه ۱ </span>
      <input name="mobile1" inputmode="numeric" maxlength="11" value="09181234567">
    </label>

    <label class="field">
      <span>شماره همراه ۲</span>
      <input name="mobile2" inputmode="numeric" maxlength="11" value="09187654321">
    </label>
  </div>

  <div class="grid-2">
    <label class="field">
      <span>تلفن ثابت</span>
      <input name="phone" inputmode="numeric" maxlength="11" value="08734212312">
    </label>

    <label class="field">
      <span>تاریخ خرید (شمسی)</span>
      <input id="purchase_date_sh" name="purchase_date_sh">
      <input type="hidden" id="purchase_date" name="purchase_date">
    </label>
  </div>

  <label class="field">
    <span>استان </span>
    <div class="custom-select" id="provinceSelect">
      <input type="hidden" name="province" id="provinceValue">
      <div class="select-display" id="provinceDisplay">انتخاب کنید</div>
      <div class="select-options" id="provinceOptions">
        <div data-value="تهران">تهران</div>
        <div data-value="البرز">البرز</div>
        <div data-value="قزوین">قزوین</div>
        <div data-value="گیلان">گیلان</div>
        <div data-value="آذربایجان شرقی">آذربایجان شرقی</div>
        <div data-value="آذربایجان غربی">آذربایجان غربی</div>
        <div data-value="اردبیل">اردبیل</div>
        <div data-value="اصفهان">اصفهان</div>
        <div data-value="ایلام">ایلام</div>
        <div data-value="بوشهر">بوشهر</div>
        <div data-value="چهارمحال و بختیاری">چهارمحال و بختیاری</div>
        <div data-value="خراسان جنوبی">خراسان جنوبی</div>
        <div data-value="خراسان رضوی">خراسان رضوی</div>
        <div data-value="خراسان شمالی">خراسان شمالی</div>
        <div data-value="خوزستان">خوزستان</div>
        <div data-value="زنجان">زنجان</div>
        <div data-value="سمنان">سمنان</div>
        <div data-value="سیستان و بلوچستان">سیستان و بلوچستان</div>
        <div data-value="فارس">فارس</div>
        <div data-value="قم">قم</div>
        <div data-value="کردستان">کردستان</div>
        <div data-value="کرمان">کرمان</div>
        <div data-value="کرمانشاه">کرمانشاه</div>
        <div data-value="کهگیلویه و بویراحمد">کهگیلویه و بویراحمد</div>
        <div data-value="گلستان">گلستان</div>
        <div data-value="لرستان">لرستان</div>
        <div data-value="مازندران">مازندران</div>
        <div data-value="مرکزی">مرکزی</div>
        <div data-value="هرمزگان">هرمزگان</div>
        <div data-value="همدان">همدان</div>
        <div data-value="یزد">یزد</div>
      </div>
    </div>
  </label>

  <label class="field">
    <span>آدرس </span>
    <textarea name="address" rows="2" placeholder="آدرس را به طور کامل و دقیق درج کنید؛ شامل خیابان، کوچه، پلاک، واحد و طبقه و..."></textarea>
  </label>
  <div class="field">
    <label>لوکیشن مشتری (لینک گوگل‌مپ)</label>
    <input type="url" name="location_url" placeholder="مثال: https://maps.app.goo.gl/..." style="direction:ltr">
  </div>

  <label class="field">
    <span>توضیحات اضافی</span>
    <textarea name="notes" rows="2" placeholder="هرگونه توضیحات اضافه در مورد شرایط پرداخت مشتری و یا تحویل و ... را اینجا درج کنید..."></textarea>
  </label>
</section>

<!-- =================== اقلام فاکتور =================== -->
<section class="card">
  <div class="brand" style="justify-content:space-between;">
    <h3>اقلام فاکتور</h3>
    <button class="btn ghost" type="button" id="addItemBtn">+ افزودن قلم</button>
  </div>

  <div id="itemsWrap"></div>

  <template id="itemTpl">
    <div class="itemRow">

      <!-- ردیف اول: مدل – قیمت -->
      <div class="grid-3">

        <!-- مدل کالا (جستجو از جدول product: فقط title) -->
        <label class="field">
          <span>مدل / عنوان کالا</span>
          <select class="modelSearch" name="items[][model_id]" required></select>

          <!-- فیلد متنی واقعی که در دیتابیس ذخیره می‌شود (title فارسی یا متن آزاد) -->
          <input type="hidden" name="items[][model]" class="modelInput">

          <!-- برای سازگاری با ساختار قدیمی، خالی می‌مانند -->
          <input type="hidden" name="items[][brand]" class="brandName">
          <input type="hidden" name="items[][category]" class="categoryName">
        </label>

        <!-- قیمت کل فروش -->
        <label class="field">
          <span>قیمت کل فروش</span>
          <input type="text" class="numFormat" name="items[][price]" value="0">
        </label>

        <div class="field"></div>
      </div>

      <!-- ردیف دوم: تعداد – نوع گارانتی -->
      <div class="grid-3">
        <label class="field">
          <span>تعداد</span>
          <input type="text" class="numFormat qtyInput" name="items[][qty]" value="1">
        </label>

        <label class="field">
          <span>نوع گارانتی</span>
          <select name="items[][warranty_type]" class="warrantySelect">
            <option value="none" selected> (۰٪)بدون گارانتی</option>
            <option value="tv_silver">(2٪)گارانتی نقره‌ای تلویزیون</option>
            <option value="tv_gold">(5٪)گارانتی طلایی تلویزیون</option>
            <option value="home_appliance">(3٪)گارانتی لوازم خانگی</option>
            <option value="small_appliance"> (2٪)گارانتی لوازم ریز</option>
          </select>
        </label>

        <div class="field"></div>
      </div>

      <!-- ردیف سوم: بیعانه – دریافتی -->
      <div class="grid-3">
        <label class="field">
          <span>بیعانه (تومان)</span>
          <input type="text" class="numFormat" name="items[][deposit]" value="0">
        </label>

        <label class="field">
          <span>دریافتی (واریزی مبلغ اضافه)</span>
          <input type="text" class="numFormat" name="items[][cod]" value="0">
        </label>

        <div class="field"></div>
      </div>

      <!-- ردیف چهارم: مانده – حذف -->
      <div class="grid-3">
        <label class="field">
          <span>مانده کل</span>
          <input type="text" class="numFormat" name="items[][remaining]" value="0" readonly>
        </label>

        <div class="field">
          <span>&nbsp;</span>
          <button type="button" class="btn danger removeItemBtn">حذف</button>
        </div>

        <div class="field"></div>
      </div>

      <!-- توضیحات -->
      <label class="field" style="margin-top:10px;">
        <span>توضیحات </span>
        <textarea name="items[][notes]" rows="2" placeholder="توضیحات مربوط به نحوه پرداخت، شرایط تحویل و ..." ></textarea>
      </label>

      <hr>
    </div>
  </template>
</section>

<!-- =================== خلاصه مبالغ =================== -->
<section class="card">
  <div class="summary-bar">
    <div class="summary-card summary-total">
      <span class="summary-label">جمع کل</span>
      <span class="summary-value" id="sumTotal">0</span>
    </div>

    <div class="summary-card summary-deposit">
      <span class="summary-label">جمع بیعانه</span>
      <span class="summary-value" id="sumDeposit">0</span>
    </div>

    <div class="summary-card summary-received">
      <span class="summary-label">جمع دریافتی</span>
      <span class="summary-value" id="sumReceived">0</span>
    </div>

    <div class="summary-card summary-remaining">
      <span class="summary-label">جمع مانده</span>
      <span class="summary-value" id="sumRemaining">0</span>
    </div>
  </div>
</section>

<!-- =================== تحلیل سود =================== -->
<section class="card" id="profitSection" style="display:none;">
  <div class="brand" style="justify-content:space-between;">
    <h3>تحلیل سود و هزینه‌ها</h3>
  </div>
  <div class="table-responsive">
    <table class="table" id="profitTable">
      <thead>
        <tr>
          <th>مدل</th>
          <th>تعداد</th>
          <th>قیمت خرید (واحد)</th>
          <th>هزینه حمل</th>
          <th>% گارانتی</th>
          <th>سایر هزینه‌ها</th>
          <th>عنوان هزینه</th>
          <th>فروش کل</th>
          <th>سود نهایی</th>
        </tr>
      </thead>
      <tbody id="profitRows"></tbody>
    </table>
  </div>
</section>

<!-- =================== برداشت از حساب =================== -->
<section class="card" style="display:none">
  <h3>برداشت از حساب (اختیاری)</h3>
  <div class="grid-2">
    <label class="field">
      <span>مبلغ برداشت</span>
      <input name="withdraw_amount" class="numFormat" type="text" value="0">
    </label>

    <label class="field">
      <span>توضیح برداشت</span>
      <input name="withdraw_note">
    </label>
  </div>
</section>

<section class="card-group">
  <section class="card">
    <h3>ارجاع به مسئول خرید</h3>

    <div class="field">
      <label>انتخاب مسئول خرید</label>
      <select name="buyer_username" id="buyerSelect">
        <option value="">بدون ارجاع</option>
        <?php foreach ($buyers as $b): ?>
          <option value="<?=$b['username']?>">
            <?=$b['full_name'] ?: $b['username']?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
  </section>

  <!-- =================== ارسال تلگرام =================== -->
<section class="card">
  <h3>ارسال تلگرام</h3>

  <fieldset class="targets">
    <legend>ارسال شود به:</legend>

    <?php foreach ($telegram_channels as $tc): ?>
      <label>
        <input type="checkbox" name="target[]" value="<?=$tc['code']?>">
        <?=$tc['label']?>
      </label>
    <?php endforeach; ?>

  </fieldset>
</section>


<div class="card">
  <button class="button">ثبت و ارسال</button>
</div>


</form>
</div>

<script>
document.getElementById('assignToBuyerChk').addEventListener('change', function(){
  const sel = document.getElementById('buyerSelect');
  sel.disabled = !this.checked;
  if (!this.checked) sel.value = '';
});
</script>
<!-- =================== اسکریپت‌های اصلی فرم =================== -->
<script>
// ================== جستجوی مدل بر اساس عنوان فارسی (product: id,title) ==================
function initModelSearch($el){
  $el.select2({
    placeholder: "جستجوی مدل...",
    minimumInputLength: 1,
    dir: "rtl",
    tags: true,
    createTag: function(params){
      return {
        id: 0,
        text: params.term,
        title: params.term,
        is_manual: true
      };
    },
    ajax: {
      url: "/orders/ajax/search_title.php",
      dataType: "json",
      delay: 200,
      data: function(params){
        return { q: params.term };
      },
      processResults: function(data){
        return {
          results: data.map(function(item){
            return {
              id: item.id,
              text: item.title || item.text,
              title: item.title || item.text
            };
          })
        };
      }
    }
  }).on("select2:select", function(e){
    const d   = e.params.data;
    const row = $(this).closest(".itemRow");
    const title = d.title || d.text || "";
    row.find(".modelInput").val(title);
    row.find(".brandName").val('');
    row.find(".categoryName").val('');
  });
}

$(function(){
  // ================== تقویم شمسی ==================
  $("#purchase_date_sh").persianDatepicker({
    format: "YYYY/MM/DD",
    autoClose: true,
    initialValue: true,
    observer: true,
    onSelect: function(unix){
      const g = new persianDate(unix).toCalendar('gregorian').format("YYYY-MM-DD");
      $("#purchase_date").val(g);
    }
  });
  $("#purchase_date").val(new persianDate().toCalendar('gregorian').format("YYYY-MM-DD"));

  // ================== فرمت عدد ==================
  $(document).on('input', '.numFormat', function(e){
    let cursorPos = this.selectionStart;
    let oldLength = this.value.length;

    let raw = this.value
      .replace(/[۰-۹]/g, d => String(d.charCodeAt(0) - 1776))
      .replace(/[٠-٩]/g, d => String(d.charCodeAt(0) - 1632));

    let val = raw.replace(/[^\d\-]/g, '');
    if (val === '') val = '0';

    let formatted = val.replace(/\B(?=(\d{3})+(?!\d))/g, ',');
    this.value = formatted;

    let newLength = this.value.length;
    this.selectionEnd = cursorPos + (newLength - oldLength);

    $(this).trigger('change');
  });

  // ================== افزودن قلم ==================
  let itemIndex = 0;
  $("#addItemBtn").click(function(){
    const tpl = $("#itemTpl").html().replace(/\[\]/g, `[${itemIndex}]`);
    $("#itemsWrap").append(tpl);
    const $row = $("#itemsWrap .itemRow").last();

    const $sel = $row.find('select.warrantySelect');
    $sel.html(`
      <option value="none" selected>بدون گارانتی (۰٪)</option>
      <option value="tv_silver">گارانتی نقره‌ای تلویزیون (2٪)</option>
      <option value="tv_gold">گارانتی طلایی تلویزیون (5٪)</option>
      <option value="home_appliance">گارانتی طلایی لوازم خانگی (3٪)</option>
      <option value="small_appliance">لوازم خانگی ریز (2٪)</option>
    `);

    initModelSearch($row.find(".modelSearch"));
    itemIndex++;
  });

  // ================== حذف قلم ==================
  $(document).on('click', '.removeItemBtn', function(){
    const row = $(this).closest('.itemRow');
    const idx = $(".itemRow").index(row);
    row.remove();

    $('#profitRows tr[data-idx="'+idx+'"]').remove();
    $(".itemRow").each(function(i){
      $('#profitRows tr[data-idx="'+(i+1)+'"]').attr('data-idx', i);
    });

    if (typeof window.recalcWithQty === 'function') window.recalcWithQty();
  });

  // ================== محاسبه مانده هر ردیف ==================
  $(document).on('input change', '.itemRow input', function(){
    const row = $(this).closest('.itemRow');
    const p = parseInt((row.find('input[name*="[price]"]').val() || '0').replace(/,/g,''))||0;
    const d = parseInt((row.find('input[name*="[deposit]"]').val()|| '0').replace(/,/g,''))||0;
    const c = parseInt((row.find('input[name*="[cod]"]').val() || '0').replace(/,/g,''))||0;
    const r = p - d - c;
    const $rem = row.find('input[name*="[remaining]"]');
    $rem.val(r.toLocaleString('en-US'));
    $rem.toggleClass('negative', r < 0);

    if (typeof window.recalcWithQty === 'function') window.recalcWithQty();
  });

  // ================== قبل ارسال: حذف ویرگول‌ها ==================
  $("#invoiceForm").on('submit', function(){
    $('.numFormat').each(function(){ this.value = this.value.replace(/,/g,''); });
    $('#profitTable input').each(function(){ this.value = this.value.replace(/,/g,''); });
  });
});
</script>

<!-- ===== اسکریپت تحلیل سود و جمع کل ===== -->
<script>
(function(){
  const nf   = n => (parseInt(n||0,10)).toLocaleString('en-US');
  const toInt= v => parseInt(String(v||'').replace(/,/g,''),10) || 0;

  const warrantyRates = {
    'none': 0,
    'tv_silver': 1.5,
    'tv_gold': 3.5,
    'home_appliance': 1.5,
    'small_appliance': 1
  };

  function ensureProfitRow(idx, modelVal, qtyVal, saleUnit, warrantyVal){
    const tbody = document.getElementById('profitRows');
    let tr = tbody.querySelector(`tr[data-idx="${idx}"]`);
    if(!tr){
      tr = document.createElement('tr');
      tr.setAttribute('data-idx', idx);
      tr.innerHTML = `
        <td><input type="text" class="modelReadonly" readonly></td>
        <td><input type="text" class="numFormat qty"></td>
        <td><input type="text" class="numFormat buyUnit"></td>
        <td><input type="text" class="numFormat shipping"></td>
        <td><input type="number" step="0.01" min="0" max="100" class="warrantyPct" placeholder="0"></td>
        <td><input type="text" class="numFormat otherCost"></td>
        <td><input type="text" class="costTitle" placeholder="علت هزینه"></td>
        <td class="saleTotal">0</td>
        <td class="profitFinal">0</td>
      `;
      tbody.appendChild(tr);

      $(tr).find('input.numFormat').on('input', function(){
        let cursorPos = this.selectionStart, oldLength = this.value.length;

        let raw = this.value
          .replace(/[۰-۹]/g, d => String(d.charCodeAt(0) - 1776))
          .replace(/[٠-٩]/g, d => String(d.charCodeAt(0) - 1632));

        let val = raw.replace(/[^\d\-\.]/g,'');
        if(val === '') val = '0';
        if(!$(this).hasClass('warrantyPct')){ val = val.replace(/\..*/,''); }
        if(!$(this).hasClass('warrantyPct')){
          val = val.replace(/\B(?=(\d{3})+(?!\d))/g, ',');
        }
        this.value = val;
        let newLength = this.value.length;
        this.selectionEnd = cursorPos + (newLength - oldLength);

        window.computeProfitRow(tr);
        window.computeProfitTotals();
        if (typeof window.recalcWithQty === 'function') window.recalcWithQty();
      });

      $(tr).find('input.warrantyPct').on('input change', function(){
        window.computeProfitRow(tr);
        window.computeProfitTotals();
      });
    }

    $(tr).find('input.modelReadonly').val(modelVal || '');
    const $qty = $(tr).find('input.qty');
    if(!$qty.val()) $qty.val(nf(qtyVal || 1));

    const qty = toInt($qty.val());
    const saleTotal = (toInt(saleUnit) * qty);
    $(tr).find('.saleTotal').text(nf(saleTotal));

    const pct = warrantyRates[warrantyVal] ?? 0;
    $(tr).find('input.warrantyPct').val(pct);

    window.computeProfitRow(tr);
    window.computeProfitTotals();
  }

  window.computeProfitRow = function(tr){
    const $tr = $(tr);
    const qty         = toInt($tr.find('input.qty').val());
    const buyUnit     = toInt($tr.find('input.buyUnit').val());
    const shipping    = toInt($tr.find('input.shipping').val());
    const otherCost   = toInt($tr.find('input.otherCost').val());
    const pctStr      = ($tr.find('input.warrantyPct').val() ?? '').toString().replace(/,/g,'');
    const warrantyPct = parseFloat(pctStr || '0') || 0;

    const saleTotal   = toInt($tr.find('.saleTotal').text());
    const profitBefore = saleTotal - (buyUnit * qty) - shipping - otherCost;
    const warrantyCut = Math.round(saleTotal * (warrantyPct / 100));
    const profitFinal  = profitBefore - warrantyCut;
    $tr.find('.profitFinal').text(nf(profitFinal));
  }

  window.computeProfitTotals = function(){
    let total = 0;
    $('#profitRows .profitFinal').each(function(){
      total += toInt($(this).text());
    });
    $('#totalFinalProfit').text(nf(total))
                          .css('color', total<0 ? '#dc2626' : '');
  }

  function recalcWithQty(){
    let sumP=0,sumD=0,sumC=0,sumR=0;

    $(".itemRow").each(function(rowIdx){
      const $row   = $(this);
      const unit   = toInt($row.find('input[name*="[price]"]').val());
      const dep    = toInt($row.find('input[name*="[deposit]"]').val());
      const cod    = toInt($row.find('input[name*="[cod]"]').val());
      const qty    = Math.max(1, toInt($row.find('input[name*="[qty]"]').val()) || 1);
      const wVal   = $row.find('select.warrantySelect').val() || 'none';

      const sale = unit * qty;
      const rem  = sale - dep - cod;

      const $rem = $row.find('input[name*="[remaining]"]');
      $rem.val(nf(rem)).toggleClass('negative', rem<0);

      sumP += sale; 
      sumD += dep; 
      sumC += cod; 
      sumR += rem;

      const selText = $row.find(".select2-selection__rendered").text();
      const modelVal = selText || $row.find('input[name*="[model]"]').val() || '';
      ensureProfitRow(rowIdx, modelVal, qty, unit, wVal);

      const tr = document.querySelector(`#profitRows tr[data-idx="${rowIdx}"]`);
      if(tr){
        $(tr).find('.saleTotal').text(nf(sale));
        window.computeProfitRow(tr);
      }
    });

    $('#sumTotal').text(nf(sumP));
    $('#sumDeposit').text(nf(sumD));
    $('#sumReceived').text(nf(sumC));
    $('#sumRemaining')
      .text(nf(sumR))
      .toggleClass('negative', sumR < 0);

    window.computeProfitTotals();
  }

  window.recalcWithQty = recalcWithQty;
  $(document).ready(function(){ setTimeout(recalcWithQty, 0); });

})();
</script>

<!-- ===== UX ریزه‌کاری‌ها ===== -->
<script>
$(document).on('keydown', 'input, select, textarea', function(e) {
  if (e.key === 'Enter') {
    e.preventDefault();
    const fields = $('input, select, textarea').filter(':visible:not([readonly]):not([disabled])');
    const index = fields.index(this);
    if (index > -1 && index + 1 < fields.length) {
      fields.eq(index + 1).focus();
    } else {
      fields.eq(0).focus();
    }
  }
});

if (/Mobi|Android|iPhone|iPad|iPod/i.test(navigator.userAgent)) {
  const profitSection = document.getElementById('profitSection');
  $(document).on('focus', '#profitSection input, #profitSection select, #profitSection textarea', function() {
    setTimeout(() => {
      profitSection.scrollIntoView({ block: 'center', behavior: 'smooth' });
      window.scrollBy(0, -80);
    }, 250);
  });
}

document.addEventListener('DOMContentLoaded', function() {
  const select  = document.getElementById('provinceSelect');
  const display = document.getElementById('provinceDisplay');
  const options = document.getElementById('provinceOptions');
  const hidden  = document.getElementById('provinceValue');

  display.addEventListener('click', () => {
    options.style.display = options.style.display === 'block' ? 'none' : 'block';
  });

  options.querySelectorAll('div').forEach(opt => {
    opt.addEventListener('click', () => {
      hidden.value = opt.getAttribute('data-value');
      display.textContent = opt.textContent;
      options.style.display = 'none';
    });
  });
});

const defaultValues = [
  "محمد عزیزی",
  "09181234567",
  "09187654321",
  "08734212312"
];

document.addEventListener("focusin", function(e) {
  const el = e.target;
  if (el.tagName !== "INPUT" && el.tagName !== "TEXTAREA") return;

  setTimeout(() => {
    el.scrollIntoView({ behavior: "smooth", block: "center" });
  }, 200);

  if (el.readOnly) return;

  const val = (el.value || '').trim();

  if (defaultValues.includes(val)) {
    el.value = "";
    return;
  }

  if (el.classList.contains('numFormat') && (val === "0" || val === "1")) {
    el.value = "";
  }
});
</script>

<!-- ========= سیستم استخراج هوشمند متن واتساپ / تلگرام ========= -->
<script>
document.getElementById('parseQuickPaste').addEventListener('click', function(){

  const raw = document.getElementById('quickPaste').value.trim();
  if(!raw){
    alert("متن خالی است!");
    return;
  }

  const lines = raw.split("\n")
    .map(x => x.trim())
    .filter(x => x !== "");

  if(lines.length < 8){
    alert("حداقل ۸ خط لازم است (نام، موبایل‌ها، ثابت، تاریخ، آدرس، لوکیشن، توضیحات)");
    return;
  }

  function detectProvince(address){
    const clean = address
      .replace(/\s+/g, ' ')
      .replace(/[،٬]/g, '') 
      .trim();

    const provinces = [
      "تهران","البرز","اصفهان","آذربایجان شرقی","آذربایجان غربی","فارس",
      "خراسان رضوی","خوزستان","گیلان","مازندران","قم","کرمان",
      "سیستان و بلوچستان","هرمزگان","کردستان","کرمانشاه","گلستان",
      "قزوین","مرکزی","یزد","اردبیل","زنجان","چهارمحال و بختیاری",
      "همدان","کهگیلویه و بویراحمد","ایلام","لرستان","بوشهر",
      "خراسان شمالی","خراسان جنوبی"
    ];

    for(const p of provinces){
      if(clean.includes(p)) return p;
    }
    return "";
  }

  function detectWarranty(text){
    const t = text
      .trim()
      .toLowerCase()
      .replace(/[‌\u200c]/g, '');

    if(/بدون|بی|none/.test(t)) return "none";
    if(/طلایی/.test(t) && /تل/.test(t)) return "tv_gold";
    if(/نقره/.test(t) && /تل/.test(t)) return "tv_silver";
    if(/طلایی/.test(t) && /خان/.test(t)) return "home_appliance";
    if(/ریز|small/.test(t)) return "small_appliance";
    if(/طل/.test(t)) return "tv_gold";
    if(/نقر/.test(t)) return "tv_silver";
    return "none";
  }

  function detectCategory(model){
    model = model.toLowerCase();
    const map = {
      tv: ["65","55","77","tv","oled","qled","uhd","تلویزیون"],
      soundbar: ["sn","sr","sb","ساندبار","سینما"],
      fridge: ["rt","rl","یخچال","فریزر"],
      washer: ["v","j","f4","لباس","شویی"],
      microwave: ["mc","مایکرو","مایکروویو"],
      vacuum: ["bgl","جارو"],
      monitor: ["vg","vp","مانیتور"],
      speaker: ["party","اسپیکر"],
      oven: ["فرتوکار"]
    };
    for(const key in map){
      for(const tag of map[key]){
        if(model.includes(tag)) return key;
      }
    }
    return "other";
  }

  $('input[name="customer_name"]').val(lines[0] || "");
  $('input[name="mobile1"]').val(lines[1] || "");
  $('input[name="mobile2"]').val(lines[2] || "");
  $('input[name="phone"]').val(lines[3] || "");
  $('#purchase_date_sh').val(lines[4] || "");

  const address = lines[5] || "";
  $('textarea[name="address"]').val(address);

  const location = lines[6] || "";
  $('input[name="location_url"]').val(location);

  const notes = lines[7] || "";
  $('textarea[name="notes"]').val(notes);

  const province = detectProvince(address);
  if(province){
    $("#provinceValue").val(province);
    $("#provinceDisplay").text(province);
  }

  let index = 8;
  let item = 0;

  while(index + 4 < lines.length){

    const model    = lines[index];
    const price    = lines[index+1];
    const deposit  = lines[index+2];
    const cod      = lines[index+3];
    const warranty = lines[index+4];

    if(!model) break;

    $("#addItemBtn").click();

    $(`input[name="items[${item}][model]"]`).val(model);
    $(`input[name="items[${item}][price]"]`).val(price.replace(/,/g,''));
    $(`input[name="items[${item}][deposit]"]`).val(deposit.replace(/,/g,''));
    $(`input[name="items[${item}][cod]"]`).val(cod.replace(/,/g,''));

    $(`select[name="items[${item}][warranty_type]"]`)
      .val(detectWarranty(warranty));

    item++;
    index += 5;
  }

  alert("👌 اطلاعات با موفقیت استخراج شد — تعداد کالا: " + item);
});
</script>


<style>
.select2-container * {
  font-family: 'IRANSans', 'IRANSansWeb', sans-serif !important;
}
.select2-selection--single {
  height: 44px !important;
  padding: 6px 10px !important;
  border: 1px solid #d1d5db !important;
  border-radius: 10px !important;
  font-size: 14px !important;
  display: flex !important;
  align-items: center !important;
  background: #fff !important;
}
.select2-selection__rendered {
  font-size: 14px !important;
  color: #111 !important;
}
.select2-search__field {
  border: 1px solid #ddd !important;
  border-radius: 8px !important;
  padding: 8px 10px !important;
  font-size: 14px !important;
}
.select2-results__option {
  padding: 10px !important;
  font-size: 14px !important;
}
.select2-results__option--highlighted {
  background: #fee2e2 !important;
  color: #b91c1c !important;
}
</style>

</body>
</html>
