<?php
require __DIR__ . '/includes/auth.php';
require __DIR__ . '/includes/config.php';
require __DIR__ . '/includes/db_connect.php';
require __DIR__ . '/includes/header.php';

$username = $_SESSION['username'] ?? '';

if (!$username) {
    http_response_code(403);
    echo "اول وارد شوید.";
    exit;
}

// مارک به عنوان خوانده شده
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = (int)($_POST['id'] ?? 0);
    if ($id > 0) {
        $mysqli->query("
          UPDATE notifications
          SET is_read=1
          WHERE id=$id AND username='".$mysqli->real_escape_string($username)."'
        ");
    }
}

$q = $mysqli->query("
  SELECT *
  FROM notifications
  WHERE username='".$mysqli->real_escape_string($username)."'
  ORDER BY id DESC
  LIMIT 100
");
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="utf-8">
  <title>اعلان‌ها</title>
  <link rel="stylesheet" href="assets/order.css">
</head>
<body>
<div class="container">
  <h1>اعلان‌ها</h1>

  <table class="list-table">
    <thead>
      <tr>
        <th>عنوان</th>
        <th>متن</th>
        <th>سفارش</th>
        <th>زمان</th>
        <th>وضعیت</th>
      </tr>
    </thead>
    <tbody>
      <?php while($n = $q->fetch_assoc()): ?>
      <tr class="<?=$n['is_read'] ? 'read' : 'unread'?>">
        <td><?=htmlspecialchars($n['title'])?></td>
        <td><?=nl2br(htmlspecialchars($n['message']))?></td>
        <td>
          <?php if ($n['order_id']): ?>
            <a href="view.php?id=<?=$n['order_id']?>">مشاهده سفارش</a>
          <?php endif; ?>
        </td>
        <td><?=$n['created_at']?></td>
        <td>
          <?php if (!$n['is_read']): ?>
          <form method="post">
            <input type="hidden" name="id" value="<?=$n['id']?>">
            <button>خوانده شد</button>
          </form>
          <?php else: ?>
            خوانده شده
          <?php endif; ?>
        </td>
      </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>
</body>
</html>
