<?php
require_once __DIR__ . '/../includes/util.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/auth.php';
require_login();
$id = intval($_GET['id'] ?? 0);
$f = $pdo->prepare("SELECT * FROM forms WHERE id=?"); $f->execute([$id]); $form = $f->fetch(PDO::FETCH_ASSOC);
if(!$form) die("Form not found");
$page_title = "فیلدهای فرم: ".$form['title'];

// add field
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action']??'')==='add_field'){
  $label = trim($_POST['label']??'');
  $name = trim($_POST['name']??'');
  $type = $_POST['type'] ?? 'text';
  if ($label!=='' && $name!==''){
    $st = $pdo->prepare("INSERT INTO form_fields (form_id, label, name, type, sort_order) VALUES (?,?,?,?,?)");
    $sort = intval($pdo->query("SELECT COALESCE(MAX(sort_order),0)+1 FROM form_fields WHERE form_id=$id")->fetchColumn());
    $st->execute([$id, $label, $name, $type, $sort]);
    header("Location: form_edit.php?id=$id"); exit;
  }
}
$fields = $pdo->query("SELECT * FROM form_fields WHERE form_id=$id ORDER BY sort_order ASC")->fetchAll(PDO::FETCH_ASSOC);
include __DIR__.'/_header.php';
?>
<div class="card">
  <h3>فیلدها</h3>
  <table>
    <tr><th>برچسب</th><th>name</th><th>نوع</th></tr>
    <?php foreach($fields as $fl): ?>
    <tr>
      <td><?php echo e($fl['label']); ?></td>
      <td><?php echo e($fl['name']); ?></td>
      <td><?php echo e($fl['type']); ?></td>
    </tr>
    <?php endforeach; ?>
  </table>
</div>
<div class="card">
  <h3>افزودن فیلد</h3>
  <form method="post" class="grid">
    <input type="hidden" name="action" value="add_field">
    <div><label>برچسب</label><input name="label" required></div>
    <div><label>name</label><input name="name" required></div>
    <div><label>نوع</label>
      <select name="type">
        <option value="text">text</option>
        <option value="textarea">textarea</option>
        <option value="email">email</option>
        <option value="number">number</option>
        <option value="file">file</option>
      </select>
    </div>
    <div class="actions"><button class="btn">افزودن</button></div>
  </form>
</div>
<?php include __DIR__.'/_footer.php'; ?>
