<?php
require_once __DIR__ . '/../includes/util.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/auth.php';
require_login();
$page_title = "فرم‌ها";

// Create form
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action']??'')==='create'){
  $title = trim($_POST['title']??'');
  $slug = trim($_POST['slug']??'');
  if ($title!=='' && $slug!==''){
    $st = $pdo->prepare("INSERT INTO forms (title, slug, created_at) VALUES (?, ?, NOW())");
    $st->execute([$title, $slug]);
    header('Location: forms.php'); exit;
  }
}

// fetch
$forms = $pdo->query("SELECT * FROM forms ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
include __DIR__.'/_header.php';
?>
<div class="card">
  <h3>فرم‌های موجود</h3>
  <table>
    <tr><th>عنوان</th><th>Slug</th><th>عملیات</th></tr>
    <?php foreach($forms as $f): ?>
    <tr>
      <td><?php echo e($f['title']); ?></td>
      <td><?php echo e($f['slug']); ?></td>
      <td class="actions">
        <a class="btn" href="form_edit.php?id=<?php echo e($f['id']); ?>">فیلدها</a>
        <a class="btn secondary" href="responses.php?form_id=<?php echo e($f['id']); ?>">پاسخ‌ها</a>
        <a class="btn" target="_blank" href="<?php echo e(base_url('public/form.php?slug='.$f['slug'])); ?>">نمایش عمومی</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </table>
</div>
<div class="card">
  <h3>ساخت فرم جدید</h3>
  <form method="post" class="grid">
    <input type="hidden" name="action" value="create">
    <div><label>عنوان</label><input name="title" required></div>
    <div><label>Slug (لاتین)</label><input name="slug" required></div>
    <div class="actions"><button class="btn">ایجاد</button></div>
  </form>
</div>
<?php include __DIR__.'/_footer.php'; ?>
