<?php
require_once __DIR__ . '/../includes/util.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/auth.php';
$err = null;

if ($_SERVER['REQUEST_METHOD']==='POST'){
  $u = trim($_POST['username'] ?? '');
  $p = trim($_POST['password'] ?? '');

  $st = $pdo->prepare("SELECT * FROM admins WHERE username=? LIMIT 1");
  $st->execute([$u]);
  $row = $st->fetch(PDO::FETCH_ASSOC);

  $ok = false;
  if ($row){
    $stored = $row['password_hash'] ?? $row['password'] ?? null;
    if ($stored){
      if (function_exists('password_verify') && password_verify($p, $stored)) $ok = true;
      elseif (function_exists('crypt') && @crypt($p, $stored)===$stored) $ok = true;
      elseif ($stored === $p) $ok = true;
    }
  }

  if ($ok && $row){
    if (function_exists('password_hash')){
      if (!isset($row['password_hash']) || !password_verify($p, $row['password_hash']) || password_needs_rehash($row['password_hash'], PASSWORD_BCRYPT)){
        $new = password_hash($p, PASSWORD_BCRYPT);
        $pdo->prepare("UPDATE admins SET password_hash=?, password=NULL WHERE id=?")->execute([$new, $row['id']]);
      }
    }
    session_regenerate_id(true);
    $_SESSION['admin'] = $row['username'];
    redirect(base_url('admin/dashboard.php'));
  } else {
    $err = '❌ نام کاربری یا رمز عبور اشتباه است.';
  }
}
?><!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8"><title>ورود مدیریت</title>
<link href="https://cdn.jsdelivr.net/gh/rastikerdar/iranyekan-font@v2.0.2/css/iranyekan.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo e(base_url('assets/css/admin.css')); ?>">
<style>body{display:flex;align-items:center;justify-content:center;min-height:100vh}</style>
</head>
<body>
<div class="card" style="width:min(420px,92vw)">
  <div style="text-align:center">
    <img src="<?php echo e(SITE_LOGO); ?>" style="height:56px">
    <h3>ورود مدیریت</h3>
  </div>
  <?php if($err): ?><div style="color:#c62828;margin:8px 0"><?php echo e($err); ?></div><?php endif; ?>
  <form method="post" autocomplete="off">
    <label>نام کاربری</label>
    <input name="username" required>
    <label>رمز عبور</label>
    <input type="password" name="password" required>
    <div class="actions" style="margin-top:10px">
      <button class="btn" type="submit">ورود</button>
      <a class="btn secondary" href="<?php echo e(base_url('/')); ?>">بازگشت</a>
    </div>
  </form>
</div>
</body></html>
