<?php
require_once __DIR__ . '/../includes/util.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/auth.php';
require_login();

$form_id = intval($_GET['form_id'] ?? 0);
$form = null;
if ($form_id>0){
  $s=$pdo->prepare("SELECT * FROM forms WHERE id=?"); $s->execute([$form_id]); $form=$s->fetch(PDO::FETCH_ASSOC);
}
$page_title = "پاسخ‌ها";
include __DIR__.'/_header.php';

if(!$form){ echo '<div class="card">فرم یافت نشد.</div>'; include __DIR__.'/_footer.php'; exit; }

$resp = $pdo->prepare("SELECT * FROM form_responses WHERE form_id=? ORDER BY id DESC");
$resp->execute([$form_id]);
$list = $resp->fetchAll(PDO::FETCH_ASSOC);

// get fields
$fields = $pdo->prepare("SELECT * FROM form_fields WHERE form_id=? ORDER BY sort_order ASC");
$fields->execute([$form_id]);
$flds = $fields->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="card">
  <h3>پاسخ‌های فرم: <?php echo e($form['title']); ?></h3>
  <table>
    <tr>
      <th>شناسه</th>
      <?php foreach($flds as $f): ?><th><?php echo e($f['label']); ?></th><?php endforeach; ?>
      <th>تاریخ</th>
    </tr>
    <?php foreach($list as $r): ?>
      <tr>
        <td><?php echo e($r['id']); ?></td>
        <?php foreach($flds as $f):
          $v = $pdo->prepare("SELECT value FROM form_response_values WHERE response_id=? AND field_id=?");
          $v->execute([$r['id'], $f['id']]);
          $val = $v->fetchColumn() ?: '';
          if ($f['type']==='file' && $val) $val = '<a class="btn" href="'.e(base_url('uploads/forms/'.$val)).'" target="_blank">دانلود</a>';
          echo '<td>'.($f['type']==='file' ? $val : e($val)).'</td>';
        endforeach; ?>
        <td><?php echo e($r['created_at']); ?></td>
      </tr>
    <?php endforeach; ?>
  </table>
</div>
<?php include __DIR__.'/_footer.php'; ?>
