<?php
require_once __DIR__ . '/../includes/util.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/auth.php';
require_login();
$page_title = "ویدیوها";
include __DIR__.'/_header.php';

$videos = $pdo->query("SELECT * FROM videos ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="card">
  <h3>آپلودهای ویدیو</h3>
  <table>
    <tr><th>شناسه</th><th>نام</th><th>موبایل</th><th>فایل</th><th>تاریخ</th></tr>
    <?php foreach($videos as $v): ?>
    <tr>
      <td><?php echo e($v['id']); ?></td>
      <td><?php echo e($v['name']); ?></td>
      <td><?php echo e($v['phone']); ?></td>
      <td><a class="btn" href="<?php echo e(base_url('uploads/videos/'.$v['file_name'])); ?>" target="_blank">دانلود</a></td>
      <td><?php echo e($v['created_at']); ?></td>
    </tr>
    <?php endforeach; ?>
  </table>
</div>
<div class="card">
  <h3>لینک عمومی آپلود</h3>
  <p><a class="btn" target="_blank" href="<?php echo e(base_url('public/video_upload.php')); ?>">باز کردن صفحه آپلود</a></p>
</div>
<?php include __DIR__.'/_footer.php'; ?>
