<?php
require_once __DIR__ . '/../includes/util.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/mailer.php';

$slug = trim($_GET['slug'] ?? '');
if ($slug==='') die("فرم یافت نشد.");

$st = $pdo->prepare("SELECT * FROM forms WHERE slug=?");
$st->execute([$slug]);
$form = $st->fetch(PDO::FETCH_ASSOC);
if (!$form) die("فرم یافت نشد.");

$fields = $pdo->prepare("SELECT * FROM form_fields WHERE form_id=? ORDER BY sort_order ASC");
$fields->execute([$form['id']]);
$flds = $fields->fetchAll(PDO::FETCH_ASSOC);

$err = null; $ok = false;
if ($_SERVER['REQUEST_METHOD']==='POST'){
  $pdo->beginTransaction();
  try {
    $pdo->prepare("INSERT INTO form_responses (form_id, created_at) VALUES (?, NOW())")->execute([$form['id']]);
    $rid = $pdo->lastInsertId();

    foreach($flds as $f){
      $val = '';
      if ($f['type']==='file'){
        if (!empty($_FILES[$f['name']]['name'])){
          $fn = time().'_'.preg_replace('/[^a-zA-Z0-9\._-]/','', $_FILES[$f['name']]['name']);
          $dest = UPLOAD_DIR . '/forms/' . $fn;
          if (move_uploaded_file($_FILES[$f['name']]['tmp_name'], $dest)){
            $val = $fn;
          }
        }
      } else {
        $val = trim($_POST[$f['name']] ?? '');
      }
      $pdo->prepare("INSERT INTO form_response_values (response_id, field_id, value) VALUES (?,?,?)")->execute([$rid, $f['id'], $val]);
    }
    $pdo->commit();
    $ok = true;

    // email notify (simple)
    $html = "<h3>فرم جدید: ".e($form['title'])."</h3><ul>";
    foreach($flds as $f){
      $v = $pdo->prepare("SELECT value FROM form_response_values WHERE response_id=? AND field_id=?");
      $v->execute([$rid, $f['id']]); $vv = $v->fetchColumn();
      $html .= "<li><b>".e($f['label']).":</b> ".e($vv)."</li>";
    }
    $html .= "</ul>";
    @sb_send_mail("ارسال جدید در فرم ".$form['title'], $html);

  } catch (Throwable $t){
    $pdo->rollBack();
    $err = "مشکل در ذخیره‌سازی.";
  }
}
?><!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8"><title><?php echo e($form['title']); ?></title>
<link href="https://cdn.jsdelivr.net/gh/rastikerdar/iranyekan-font@v2.0.2/css/iranyekan.css" rel="stylesheet">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="<?php echo e(base_url('assets/css/admin.css')); ?>">
</head>
<body>
<div class="container">
  <div class="card" style="max-width:720px;margin:24px auto">
    <div style="text-align:center"><img src="<?php echo e(SITE_LOGO); ?>" style="height:56px"></div>
    <h2><?php echo e($form['title']); ?></h2>
    <?php if($ok): ?>
      <div class="badge">ثبت شد. ممنون از شما.</div>
    <?php else: ?>
      <?php if($err): ?><div style="color:#c62828"><?php echo e($err); ?></div><?php endif; ?>
      <form method="post" enctype="multipart/form-data" class="grid">
        <?php foreach($flds as $f): ?>
          <div>
            <label><?php echo e($f['label']); ?></label>
            <?php if($f['type']==='textarea'): ?>
              <textarea name="<?php echo e($f['name']); ?>"></textarea>
            <?php elseif($f['type']==='file'): ?>
              <input type="file" name="<?php echo e($f['name']); ?>">
            <?php else: ?>
              <input type="<?php echo e($f['type']); ?>" name="<?php echo e($f['name']); ?>">
            <?php endif; ?>
          </div>
        <?php endforeach; ?>
        <div class="actions"><button class="btn">ارسال</button></div>
      </form>
    <?php endif; ?>
  </div>
</div>
</body></html>
