<?php
require_once __DIR__ . '/../includes/util.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/mailer.php';

$err=null; $ok=false;
if ($_SERVER['REQUEST_METHOD']==='POST'){
  $name = trim($_POST['name'] ?? '');
  $phone = trim($_POST['phone'] ?? '');

  if (empty($_FILES['video']['name'])) $err = 'ویدیو انتخاب نشده است.';
  else {
    if ($_FILES['video']['size'] > bytes_from_mb(VIDEO_MAX_MB)) $err = 'حجم فایل بیش از حد مجاز است.';
  }

  if (!$err){
    $safe = time().'_'.preg_replace('/[^a-zA-Z0-9\._-]/','', $_FILES['video']['name']);
    $dest = UPLOAD_DIR . '/videos/' . $safe;
    if (!move_uploaded_file($_FILES['video']['tmp_name'], $dest)){
      $err = 'آپلود ناموفق بود.';
    } else {
      $pdo->prepare("INSERT INTO videos (name, phone, file_name, created_at) VALUES (?,?,?,NOW())")->execute([$name,$phone,$safe]);
      $ok = true;
      @sb_send_mail("آپلود ویدیو جدید", "<p>نام: ".e($name)."</p><p>موبایل: ".e($phone)."</p><p>فایل: ".$safe."</p>");
    }
  }
}
?><!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8"><title>ارسال ویدیو</title>
<link href="https://cdn.jsdelivr.net/gh/rastikerdar/iranyekan-font@v2.0.2/css/iranyekan.css" rel="stylesheet">
<link rel="stylesheet" href="<?php echo e(base_url('assets/css/admin.css')); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body>
<div class="container">
  <div class="card" style="max-width:720px;margin:24px auto">
    <div style="text-align:center"><img src="<?php echo e(SITE_LOGO); ?>" style="height:56px"></div>
    <h2>ارسال ویدیو مشتری</h2>
    <?php if($ok): ?><div class="badge">ویدیو با موفقیت آپلود شد. سپاس 🙏</div><?php endif; ?>
    <?php if($err): ?><div style="color:#c62828"><?php echo e($err); ?></div><?php endif; ?>
    <form method="post" enctype="multipart/form-data" class="grid">
      <div><label>نام</label><input name="name"></div>
      <div><label>موبایل</label><input name="phone"></div>
      <div style="grid-column:1/-1"><label>فایل ویدیو (حداکثر <?php echo e(VIDEO_MAX_MB); ?>MB)</label><input type="file" name="video" required></div>
      <div class="actions"><button class="btn">ارسال</button></div>
    </form>
  </div>
</div>
</body></html>
