<?php
require_once __DIR__.'/config.php';
$mysqli = db();
$type = $_GET['type'] ?? 'requests';
$q = trim($_GET['q'] ?? '');
$limit = 200;

if ($type === 'installs') {
  $sql = "SELECT i.id, i.tracking_code, i.installer_name, i.install_date, i.serial_number, i.created_at,
                 r.customer_name, r.province, r.model
          FROM installations i
          LEFT JOIN guarantee_requests r ON r.tracking_code=i.tracking_code
          WHERE 1";
  $bind = ''; $params=[];
  if($q!==''){
    $sql.=" AND (i.tracking_code LIKE ? OR i.installer_name LIKE ? OR r.customer_name LIKE ? OR r.model LIKE ?)";
    $like='%'.$q.'%'; $bind='ssss'; $params=[$like,$like,$like,$like];
  }
  $sql.=" ORDER BY i.id DESC LIMIT {$limit}";
} else {
  $type='requests';
  $sql="SELECT id, tracking_code, seller, customer_name, province, mobile, model, created_at FROM guarantee_requests WHERE 1";
  $bind=''; $params=[];
  if($q!==''){
    $sql.=" AND (tracking_code LIKE ? OR seller LIKE ? OR customer_name LIKE ? OR province LIKE ? OR mobile LIKE ? OR model LIKE ?)";
    $like='%'.$q.'%'; $bind='ssssss'; $params=[$like,$like,$like,$like,$like,$like];
  }
  $sql.=" ORDER BY id DESC LIMIT {$limit}";
}

$stmt=$mysqli->prepare($sql);
if($bind!==''){ $stmt->bind_param($bind, ...$params); }
$stmt->execute();
$res=$stmt->get_result();
$rows=$res->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>
<!doctype html>
<html lang="fa">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>پنل مدیریت گارانتی</title>
  <link rel="stylesheet" href="assets/admin-style.css">
</head>
<body>
<div class="container">
  <div class="header">
    <div class="bar"></div>
    <h1>پنل مدیریت گارانتی</h1>
  </div>

  <div class="tabs">
    <a class="tab <?= $type==='requests'?'active':'' ?>" href="?type=requests">درخواست‌های نصب</a>
    <a class="tab <?= $type==='installs'?'active':'' ?>" href="?type=installs">نصب‌های انجام‌شده</a>
  </div>

  <form class="toolbar" method="get">
    <input type="hidden" name="type" value="<?= htmlspecialchars($type,ENT_QUOTES) ?>">
    <input type="text" name="q" value="<?= htmlspecialchars($q,ENT_QUOTES) ?>" placeholder="جستجو... (کد، نام، مدل، استان، فروشنده)">
    <button type="submit">جستجو</button>
    <a class="button ghost" href="?type=<?= $type ?>">حذف فیلتر</a>
  </form>

  <div class="card">
  <?php if($type==='requests'): ?>
    <table>
      <thead><tr>
        <th>#</th><th>کد</th><th>فروشنده</th><th>مشتری</th><th>استان</th><th>همراه</th><th>مدل</th><th>تاریخ ثبت</th>
      </tr></thead>
      <tbody>
      <?php foreach($rows as $r): ?>
        <tr>
          <td><?= (int)$r['id'] ?></td>
          <td><code><?= htmlspecialchars($r['tracking_code']) ?></code></td>
          <td><?= htmlspecialchars($r['seller']) ?></td>
          <td><?= htmlspecialchars($r['customer_name']) ?></td>
          <td><?= htmlspecialchars($r['province']) ?></td>
          <td><?= htmlspecialchars($r['mobile']) ?></td>
          <td><?= htmlspecialchars($r['model']) ?></td>
          <td><?= htmlspecialchars($r['created_at']) ?></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  <?php else: ?>
    <table>
      <thead><tr>
        <th>#</th><th>کد</th><th>مشتری</th><th>سرویس‌کار</th><th>تاریخ نصب</th><th>سریال</th><th>مدل</th><th>استان</th><th>ثبت</th>
      </tr></thead>
      <tbody>
      <?php foreach($rows as $r): ?>
        <tr>
          <td><?= (int)$r['id'] ?></td>
          <td><code><?= htmlspecialchars($r['tracking_code']) ?></code></td>
          <td><?= htmlspecialchars($r['customer_name']) ?></td>
          <td><?= htmlspecialchars($r['installer_name']) ?></td>
          <td><?= htmlspecialchars($r['install_date']) ?></td>
          <td><?= htmlspecialchars($r['serial_number']) ?></td>
          <td><?= htmlspecialchars($r['model']) ?></td>
          <td><?= htmlspecialchars($r['province']) ?></td>
          <td><?= htmlspecialchars($r['created_at']) ?></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  <?php endif; ?>
  </div>
</div>
</body>
</html>
